var wrtc = require('electron-webrtc')()
var Peer = require('simple-peer')

var p1 = new Peer({ initiator: true, wrtc })
var p2 = new Peer({ wrtc })

p1.on('signal', p2.signal.bind(p2))
p2.on('signal', p1.signal.bind(p1))

p1.on('data', (data) => console.log('2->1', data))
p2.on('data', (data) => console.log('1->2', data))

p1.on('connect', () => {
  console.log('connect')
  p1.destroy(() => {
    p2.write('test')
  })
})
